; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "DRC"
!define PRODUCT_VERSION "2.6.1"
!define PRODUCT_PUBLISHER "Denis Sbragion"
!define PRODUCT_WEB_SITE "http://drc-fir.sourceforge.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\drc.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\drc.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Italian"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\DRC"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "sample\drc.exe"
  File "sample\glsweep.exe"
  File "sample\lsconv.exe"
  File "doc\text\drc.txt"
  File "readme.txt"
  File "COPYING"
  SetOutPath "$INSTDIR\config"
  SetOverwrite ifnewer
  File "source\config\*"
  SetOutPath "$INSTDIR\target"
  SetOverwrite ifnewer
  File "source\target\*"
  SetOutPath "$INSTDIR\mic"
  SetOverwrite ifnewer
  File "source\mic\*"
  SetOutPath "$INSTDIR\impulse"
  SetOverwrite ifnewer
  File "sample\rs.pcm"
  SetOutPath "$INSTDIR\filter"
  CreateDirectory "$SMPROGRAMS\DRC"
  CreateShortCut "$SMPROGRAMS\DRC\DRC.lnk" "$INSTDIR\drc.txt"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\DRC\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\DRC\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\drc.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\drc.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\lsconv.exe"
  Delete "$INSTDIR\glsweep.exe"
  Delete "$INSTDIR\drc.exe"
  Delete "$INSTDIR\readme.txt"
  Delete "$INSTDIR\drc.txt"
  Delete "$INSTDIR\COPYING"

  Delete "$INSTDIR\impulse\rs.pcm"

  Delete "$INSTDIR\config\erb.drc"
  Delete "$INSTDIR\config\minimal.drc"
  Delete "$INSTDIR\config\soft.drc"
  Delete "$INSTDIR\config\normal.drc"
  Delete "$INSTDIR\config\strong.drc"
  Delete "$INSTDIR\config\insane.drc"
  Delete "$INSTDIR\config\extreme.drc"
  Delete "$INSTDIR\config\optimized.drc"

  Delete "$INSTDIR\mic\wm-61a.txt"
  Delete "$INSTDIR\mic\wm-60a.txt"
  Delete "$INSTDIR\mic\ecm8000.txt"

  Delete "$INSTDIR\target\flat.txt"
  Delete "$INSTDIR\target\subultra.txt"
  Delete "$INSTDIR\target\ultra.txt"
  Delete "$INSTDIR\target\bk-spline.txt"
  Delete "$INSTDIR\target\bk-sub-spline.txt"
  Delete "$INSTDIR\target\bk-sub.txt"
  Delete "$INSTDIR\target\bk.txt"
  Delete "$INSTDIR\target\bk-2-spline.txt"
  Delete "$INSTDIR\target\bk-2-sub-spline.txt"
  Delete "$INSTDIR\target\bk-2-sub.txt"
  Delete "$INSTDIR\target\bk-2.txt"
  Delete "$INSTDIR\target\bk-3-spline.txt"
  Delete "$INSTDIR\target\bk-3-sub-spline.txt"
  Delete "$INSTDIR\target\bk-3-sub.txt"
  Delete "$INSTDIR\target\bk-3-subultra-spline.txt"
  Delete "$INSTDIR\target\bk-3.txt"

  Delete "$SMPROGRAMS\DRC\Uninstall.lnk"
  Delete "$SMPROGRAMS\DRC\Website.lnk"
  Delete "$SMPROGRAMS\DRC\DRC.lnk"

  RMDir "$SMPROGRAMS\DRC"
  RMDir "$INSTDIR\impulse"
  RMDir "$INSTDIR\config"
  RMDir "$INSTDIR\mic"
  RMDir "$INSTDIR\target"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd